package org.msh.tb.bd.tbforms.dhis2.tb11;

import org.msh.tb.entities.enums.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 20/03/2017.
 * Mock data for each block of Tb 11 Form.
 * Used to test if all data elements and COCs Ids are correct.
 * To run this test need to change code on TB11AsyncTask to use the mock data generated by this class.
 */
public class TB11MockDataResource {

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 1 will have its values starting by 1 from left -> right up -> down
     * ex:
     * 1 - 2 - 3 - 4 ...
     * 37 - 38 - 39 - 40 - 41 ...
     * ...
     * @param setAsZero
     * @return
     */
    public List<Object[]> block1(boolean setAsZero) {
        // todo
        return null;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 11 Form Block 2 will have its values starting by 5 from left -> right
     * ex:
     * 5 - 6 - 7 - 8 - 9 - 10
     * @param setAsZero
     * @return
     */
    public List<Object[]> block2(boolean setAsZero) {
        String[] types = new String[]{"TOTAL", "CPT", "ART"};
        Gender[] genders = new Gender[] {Gender.MALE,
                Gender.FEMALE};

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 5;

        for (String type : types) {
            for (Gender gender : genders) {
                res = new Object[]{type, gender, count};
                results.add(res);
                count = getNext(count, setAsZero);
            }
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 3 will have its values starting by 6 from left -> right
     * ex:
     * 6 - 7 - 8 - 9 - 10 - 11
     * @param setAsZero
     * @return
     */
    public List<Object[]> block3(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB11_IPT_COLUMN1_MALE,
                TbFormField.TB11_IPT_COLUMN1_FEMALE,
                TbFormField.TB11_IPT_COLUMN2_MALE,
                TbFormField.TB11_IPT_COLUMN2_FEMALE,
                TbFormField.TB11_IPT_COLUMN3_MALE,
                TbFormField.TB11_IPT_COLUMN3_FEMALE
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 6;

        for (TbFormField field : fields) {
            res = new Object[]{field, count};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * Check if setAsZero is true, if it is return zero, if not returns current value + 1
     * @param currentValue
     * @param setAsZero
     * @return
     */
    private Long getNext(Long currentValue, boolean setAsZero) {
        if (setAsZero) {
            return new Long(0);
        }

        return currentValue + 1;
    }
}
